<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Resources') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">

                    @foreach($folders as $folder)

                    <!-- component -->
                <a href="/resource/{{ $folder->id }}">

                    <div class="flex items-center bg-magenta-100 rounded-md p-3 text-white cursor-pointer transition duration-800 ease-in-out hover:shadow hover:bg-hotpink-100 mb-4">
                        <div>
                        <img src="/flags/{{ $folder->icon }}" width="30" height="30">
                        </div>
                        <div class="px-3 mr-auto">
                            <h4 class="font-bold">{{ $folder->name }}</h4>
                            <small class="text-xs">{{ $folder->description }}</small>
                        </div>
                        <div class="relative">

                        </div>
                    </div>

                </a>

                    
                    @endforeach
               
                </div>
            </div>
        </div>
    </div>
</x-app-layout>