<?php

namespace App\Models;

use Backpack\CRUD\app\Models\Traits\CrudTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Asset extends Model
{
    use CrudTrait;
    use HasFactory;

    protected $fillable = ['folder_id','name', 'description', 'type', 'path', 'text'];

    public function folder(): BelongsTo
    {
        return $this->belongsTo(Folder::class);
    }

}
