<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\AssetRequest;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;

/**
 * Class AssetCrudController
 * @package App\Http\Controllers\Admin
 * @property-read \Backpack\CRUD\app\Library\CrudPanel\CrudPanel $crud
 */
class AssetCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;

    /**
     * Configure the CrudPanel object. Apply settings to all operations.
     * 
     * @return void
     */
    public function setup()
    {
        CRUD::setModel(\App\Models\Asset::class);
        CRUD::setRoute(config('backpack.base.route_prefix') . '/asset');
        CRUD::setEntityNameStrings('resource', 'resources');
    }

    /**
     * Define what happens when the List operation is loaded.
     * 
     * @see  https://backpackforlaravel.com/docs/crud-operation-list-entries
     * @return void
     */
    protected function setupListOperation()
    {
       // CRUD::setFromDb(); // set columns from db columns.

        /**
         * Columns can be defined using the fluent syntax:
         * - CRUD::column('price')->type('number');
         */

        //CRUD::filter('folder')->label('Folder');

        CRUD::column([
            'label'     => 'Folder', // Table column heading
            'type'      => 'select',
            'name'      => 'folder_id', // the column that contains the ID of that connected entity;
            'entity'    => 'folder', // the method that defines the relationship in your Model
            'attribute' => 'name', // foreign key attribute that is shown to user
            'model'     => 'App\Models\Folder', // foreign key model
            ]);

        CRUD::column([   // Text
                'label' => 'Name',
                'name'  => 'name',
                'type'  => 'text',
            ]);
        
        CRUD::column([   // Text
                'name'  => 'type',
                'type'  => 'select_from_array', 
                'options'     => ['1' => 'File', '2' => 'Content', '3' => 'Video'],
            ]);

        CRUD::column([   // Text
                'label' => 'Description',
                'name'  => 'description',
                'type'  => 'textarea',
            ]);
    }

    /**
     * Define what happens when the Create operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-create
     * @return void
     */
    protected function setupCreateOperation()
    {
        CRUD::setValidation(AssetRequest::class);
       // CRUD::setFromDb(); // set fields from db columns.

       CRUD::field([
        'label'     => 'Folder', // Table column heading
        'type'      => 'select',
        'name'      => 'folder_id', // the column that contains the ID of that connected entity;
        'entity'    => 'folder', // the method that defines the relationship in your Model
        'attribute' => 'name', // foreign key attribute that is shown to user
        'model'     => 'App\Models\Folder', // foreign key model
        ]);

        CRUD::field([   // Text
            'label' => 'Name',
            'name'  => 'name',
            'type'  => 'text',
        ]);

        CRUD::field([   // Text
            'label' => 'Description',
            'name'  => 'description',
            'type'  => 'textarea',
        ]);

        CRUD::field([   // Text
            'name'  => 'type',
            'type'  => 'select_from_array', 
            'options'     => ['1' => 'File', '2' => 'Content', '3' => 'Video'],
        ]);

        CRUD::field([   // Upload
            'name'      => 'path',
            'label'     => 'File Upload',
            'type'      => 'upload',
            'withFiles' => true
        ]);

        CRUD::field([   // Text
            'label' => 'Content',
            'name'  => 'text',
            'type'  => 'summernote',
        ]);

        /**
         * Fields can be defined using the fluent syntax:
         * - CRUD::field('price')->type('number');
         */
    }

    /**
     * Define what happens when the Update operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-update
     * @return void
     */
    protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();
    }
}
